class TDP_HUD extends ChallengeHUD;

#exec OBJ LOAD FILE=..\Textures\LadrStatic.utx PACKAGE=Botpack.LadrStatic

#exec TEXTURE IMPORT NAME=Babe FILE=Textures\babe.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Blackness FILE=Textures\Blackness.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Whiteness FILE=Textures\Whiteness.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Health FILE=Textures\Icon_Health.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Armor FILE=Textures\Icon_Armor.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Ammo FILE=Textures\Icon_Ammo.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Frags FILE=Textures\Icon_Frags.bmp Group=HUD MIPS=ON

var float InfoScale;
var bool bInfoOpen, bInfoDown, bDrawInfoText, bTimeDown;
var Color InfoColor, BlackColor;
var int counter;

simulated function RenderInfo(Canvas Canvas)
{
local float XL,YL;

	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;

	Canvas.SetPos(Canvas.ClipX * 0.5 - 256 * InfoScale, Canvas.ClipY * 0.5 - 128 * InfoScale);

	Canvas.DrawTile(Texture'Babe', 512 * InfoScale, 256 * InfoScale, 0, 0, 512 , 256 );

	if ( InfoScale < 1 && !bInfoDown )
		{
		InfoScale += 0.01;
		}
	else if ( !bInfoDown )
		{
		InfoScale = 1;
		bDrawInfoText = True;
		if ( InfoColor.R < 253 && !bInfoDown)
			{
			InfoColor.R += 3;
			InfoColor.G += 3;
			InfoColor.B += 3;
			}
		else if ( !bInfoDown )
			{
			Counter++;
			InfoColor.R = 255;
			InfoColor.G = 255;
			InfoColor.B = 255;
			if ( Counter > 300 )
				{
				bInfoDown = True;
				}
			}
		}

	if ( bDrawInfoText )
		{
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.bCenter = True;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 160);
		Canvas.DrawColor = InfoColor;
		Canvas.DrawText("Welcome to TheDane's Adult server!");

		Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 128);
		Canvas.DrawText("WARNING!! This server is for adults only!");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 128 + YL);
		Canvas.DrawText("If you are not old eneough to watch pornography you must disconnect!");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 128 + 2*YL);
		Canvas.DrawText("If you don't, you agree to be legaly watching pornography!");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 128 + 3*YL);
		Canvas.DrawText("The server admin can't be held responsible for your age!");
		}
	if ( bInfoDown )
		{
		if ( InfoColor.R > 3 )
			{
			InfoColor.R -= 4;
			InfoColor.G -= 4;
			InfoColor.B -= 4;
			}
		else
			{
			if ( InfoScale > 0 )
				{
				bDrawInfoText = False;
				InfoScale -= 0.02;
				}
			else
				{
				bInfoOpen = False;
				bInfoDown = False;
				}
			}
		}
	Canvas.bCenter = False;
}

simulated function DrawAmmo(Canvas Canvas)
{
local float XL,YL;
local float DrawScale, i;

	if ( (PawnOwner.Weapon == None) || (PawnOwner.Weapon.AmmoType == None) || PawnOwner.PlayerReplicationInfo == None )
		return;

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	Canvas.SetPos(Canvas.ClipX - 32, Canvas.ClipY - 32);;
	Canvas.DrawTile(Texture'Icon_Ammo', 32, 32, 0, 0, 32, 32);
	i = 128 / PawnOwner.Weapon.AmmoType.MaxAmmo;
	DrawScale = PawnOwner.Weapon.AmmoType.AmmoAmount * i;
	if ( DrawScale < 15 )
		Canvas.DrawColor = RedColor;
	else if ( DrawScale < 35 )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = GreenColor;
	Canvas.SetPos(Canvas.ClipX - 161 , Canvas.ClipY - 26);
	Canvas.DrawTile(Texture'Whiteness', DrawScale, 20, 0, 0, 1, 1);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX - 162, Canvas.ClipY - 27);
	Canvas.DrawTile(Texture'Blackness', 129, 1, 0, 0, 1, 1);
	Canvas.SetPos(Canvas.ClipX - 162, Canvas.ClipY - 6);
	Canvas.DrawTile(Texture'Blackness', 129, 1, 0, 0, 1, 1);
	Canvas.SetPos(Canvas.ClipX - 162, Canvas.ClipY - 26);
	Canvas.DrawTile(Texture'Blackness', 1, 20, 0, 0, 1, 1);
	Canvas.SetPos(Canvas.ClipX - 34, Canvas.ClipY - 26);
	Canvas.DrawTile(Texture'Blackness', 1, 20, 0, 0, 1, 1);
	Canvas.StrLen(PawnOwner.Weapon.AmmoType.AmmoAmount, XL, YL);
	Canvas.DrawColor = BlackColor;
	Canvas.SetPos((Canvas.ClipX - 81) - 0.5 * XL, Canvas.ClipY - 24);
	Canvas.DrawText(PawnOwner.Weapon.AmmoType.AmmoAmount);

	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen(PawnOwner.Weapon.ItemName, XL, YL);
	Canvas.SetPos(Canvas.ClipX - XL, Canvas.ClipY - (32 + YL) );
	Canvas.DrawText(PawnOwner.Weapon.ItemName);
	
}

//Customized to draw: Health + Ammo + Frags
simulated function DrawBasicStats(Canvas Canvas)
{
local float XL,YL;
local float DrawScale, i;
local inventory Inv;
local int Armor, Belt;
local TournamentGameReplicationInfo TGRI;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);

	if ( PawnOwner.PlayerReplicationInfo == None )
		return;

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	//Draw Health status
	Canvas.SetPos(0, Canvas.ClipY - 32);
	Canvas.DrawTile(Texture'Icon_Health', 32, 32, 0, 0, 32, 32);
	i = 128 / 199;
	DrawScale = PawnOwner.Health * i;
	if ( DrawScale < 15 )
		Canvas.DrawColor = RedColor;
	else if ( DrawScale < 35 )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = GreenColor;
	Canvas.SetPos(35, Canvas.ClipY - 26);
	Canvas.DrawTile(Texture'Whiteness', DrawScale, 20, 0, 0, 1, 1);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(34, Canvas.ClipY - 27);
	Canvas.DrawTile(Texture'Blackness', 129, 1, 0, 0, 1, 1);
	Canvas.SetPos(34, Canvas.ClipY - 6);
	Canvas.DrawTile(Texture'Blackness', 129, 1, 0, 0, 1, 1);
	Canvas.SetPos(34, Canvas.ClipY - 26);
	Canvas.DrawTile(Texture'Blackness', 1, 20, 0, 0, 1, 1);
	Canvas.SetPos(162, Canvas.ClipY - 26);
	Canvas.DrawTile(Texture'Blackness', 1, 20, 0, 0, 1, 1);
	Canvas.StrLen(PawnOwner.Health, XL, YL);
	Canvas.DrawColor = BlackColor;
	Canvas.SetPos(100 - 0.5 * XL, Canvas.ClipY - 24);
	Canvas.DrawText(PawnOwner.Health);

	//Draw Armor status
	Canvas.SetPos(0, Canvas.ClipY - 64);
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawTile(Texture'Icon_Armor', 32, 32, 0, 0, 32, 32);
	for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
		{ 
		if (Inv.bIsAnArmor) 
			{
			if ( Inv.IsA('UT_Shieldbelt') )
				Belt += Inv.Charge;
			else
				Armor += Inv.Charge;
			}
		}
	if ( Belt > Armor )
		i = Belt;
	else
		i = Armor;
	DrawScale = 128 / 150 * i;
	if ( DrawScale < 15 )
		Canvas.DrawColor = RedColor;
	else if ( DrawScale < 35 )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = GreenColor;
	Canvas.SetPos(35, Canvas.ClipY - 58);
	Canvas.DrawTile(Texture'Whiteness', DrawScale, 20, 0, 0, 1, 1);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(34, Canvas.ClipY - 59);
	Canvas.DrawTile(Texture'Blackness', 129, 1, 0, 0, 1, 1);
	Canvas.SetPos(34, Canvas.ClipY - 38);
	Canvas.DrawTile(Texture'Blackness', 129, 1, 0, 0, 1, 1);
	Canvas.SetPos(34, Canvas.ClipY - 58);
	Canvas.DrawTile(Texture'Blackness', 1, 20, 0, 0, 1, 1);
	Canvas.SetPos(162, Canvas.ClipY - 58);
	Canvas.DrawTile(Texture'Blackness', 1, 20, 0, 0, 1, 1);
	Canvas.StrLen(int(i), XL, YL);
	Canvas.DrawColor = BlackColor;
	Canvas.SetPos(100 - 0.5 * XL, Canvas.ClipY - 56);
	Canvas.DrawText(int(i));

	//Draw Frags
	Canvas.SetPos(0, Canvas.ClipY - 96);
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawTile(Texture'Icon_Frags', 32, 32, 0, 0, 32, 32);
	i = 128 / TGRI.FragLimit;
	DrawScale = PawnOwner.PlayerReplicationInfo.Score * i;
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos(35, Canvas.ClipY - 90);
	Canvas.DrawTile(Texture'Whiteness', DrawScale, 20, 0, 0, 1, 1);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(34, Canvas.ClipY - 91);
	Canvas.DrawTile(Texture'Blackness', 129, 1, 0, 0, 1, 1);
	Canvas.SetPos(34, Canvas.ClipY - 71);
	Canvas.DrawTile(Texture'Blackness', 129, 1, 0, 0, 1, 1);
	Canvas.SetPos(34, Canvas.ClipY - 90);
	Canvas.DrawTile(Texture'Blackness', 1, 20, 0, 0, 1, 1);
	Canvas.SetPos(162, Canvas.ClipY - 90);
	Canvas.DrawTile(Texture'Blackness', 1, 20, 0, 0, 1, 1);
	Canvas.StrLen(int(PawnOwner.PlayerReplicationInfo.Score)$"/"$TGRI.FragLimit, XL, YL);
	Canvas.DrawColor = BlackColor;
	Canvas.SetPos(100 - 0.5 * XL, Canvas.ClipY - 88);
	Canvas.DrawText(int(PawnOwner.PlayerReplicationInfo.Score)$"/"$TGRI.FragLimit);
}

simulated function DrawGameSynopsis(Canvas Canvas)
{
	local float XL, YL, XOffset, YOffset;
	local int MaxPlayers;
	local string Spread;

	if ( (PawnOwner.PlayerReplicationInfo == None) 
		|| PawnOwner.PlayerReplicationInfo.bIsSpectator 
		|| (PlayerCount == 1) )
		return;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;

	Canvas.bCenter = True;

	// Rank String
	Canvas.StrLen(RankString, XL, YL);

	YOffset = Canvas.ClipY - 2 * YL;

	Canvas.SetPos(0, YOffset);
	if (bTiedScore)
		Canvas.DrawColor = RedColor;
	Canvas.DrawText(RankString$" "$Rank@"/"@PlayerCount, False);
	Canvas.DrawColor = WhiteColor;

	// Spread String
	Canvas.SetPos(0, YOffset + YL);
	if (Lead > 0)
		Spread = SpreadString$" +"$Lead;
	else
		Spread = SpreadString$" "$Lead;

	Canvas.DrawText(Spread, False);

	Canvas.bCenter = False;
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTimeInfo( canvas Canvas )
{
local int Hours, Minutes, Seconds;
local float XL, YL;
local PlayerPawn PlayerOwner;

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);

	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
		{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			{
			Canvas.StrLen("00:00", XL, YL);
			Canvas.SetPos(Canvas.ClipX - XL, 0);	
			Canvas.DrawText("00:00", true);
			}
		else
			{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.StrLen(TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), XL, YL);
			Canvas.SetPos(Canvas.ClipX - XL, 0);
			Canvas.DrawText(TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
			}
		}
	else
		{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.StrLen(TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), XL, YL);
		Canvas.SetPos(Canvas.ClipX - XL, 0);
		Canvas.DrawText(TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
}

simulated function PostRender( canvas Canvas )
{
	local float XL, YL, XPos, YPos, FadeValue;
	local string Message;
	local int M, i, j, k, XOverflow;
	local float OldOriginX;

	HUDSetup(canvas);
	if ( (PawnOwner == None) || (PlayerOwner.PlayerReplicationInfo == None) )
		return;

	if ( bInfoOpen )
		{
		RenderInfo(Canvas);
		return;
		}

	if ( bShowInfo )
	{
		ServerInfo.RenderInfo( Canvas );
		return;
	}

	DrawBasicStats(Canvas);	//Cusomized version
	DrawTimeInfo(canvas);

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	OldOriginX = Canvas.OrgX;
	// Master message short queue control loop.
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	Canvas.SetClip(768*Scale - 10, Canvas.ClipY);
	bDrawFaceArea = false;
	if ( !bHideFaces && !PlayerOwner.bShowScores && !bForceScores && !bHideHUD 
			&& !PawnOwner.PlayerReplicationInfo.bIsSpectator && (Scale >= 0.4) )
	{
		//DrawSpeechArea(Canvas, XL, YL);
		bDrawFaceArea = (FaceTexture != None) && (FaceTime > Level.TimeSeconds);
		if ( bDrawFaceArea )
		{
			if ( !bHideHUD && ((PawnOwner.PlayerReplicationInfo == None) || !PawnOwner.PlayerReplicationInfo.bIsSpectator) )
				Canvas.SetOrigin( FMax(YL*4 + 8, 70*Scale) + 7*Scale + 6 + FaceAreaOffset, Canvas.OrgY );
		}
	}

	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message != None )
		{
			j++;

			if ( bResChanged || (ShortMessageQueue[i].XL == 0) )
			{
				if ( ShortMessageQueue[i].Message.Default.bComplexString )
					Canvas.StrLen(ShortMessageQueue[i].Message.Static.AssembleString( 
											self,
											ShortMessageQueue[i].Switch,
											ShortMessageQueue[i].RelatedPRI,
											ShortMessageQueue[i].StringMessage), 
								   ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				else
					Canvas.StrLen(ShortMessageQueue[i].StringMessage, ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				Canvas.StrLen("TEST", XL, YL);
				ShortMessageQueue[i].numLines = 1;
				if ( ShortMessageQueue[i].YL > YL )
				{
					ShortMessageQueue[i].numLines++;
					for (k=2; k<4-i; k++)
					{
						if (ShortMessageQueue[i].YL > YL*k)
							ShortMessageQueue[i].numLines++;
					}
				}
			}

			// Keep track of the amount of lines a message overflows, to offset the next message with.
			Canvas.SetPos(6, 2 + YL * YPos);
			YPos += ShortMessageQueue[i].numLines;
			if ( YPos > 4 )
				break; 

			if ( ShortMessageQueue[i].Message.Default.bComplexString )
			{
				// Use this for string messages with multiple colors.
				ShortMessageQueue[i].Message.Static.RenderComplexMessage( 
					Canvas,
					ShortMessageQueue[i].XL,  YL,
					ShortMessageQueue[i].StringMessage,
					ShortMessageQueue[i].Switch,
					ShortMessageQueue[i].RelatedPRI,
					None,
					ShortMessageQueue[i].OptionalObject
					);				
			} 
			else
			{
				Canvas.DrawColor = ShortMessageQueue[i].Message.Default.DrawColor;
				Canvas.DrawText(ShortMessageQueue[i].StringMessage, False);
			}
		}
	}

	Canvas.DrawColor = WhiteColor;
	Canvas.SetClip(OldClipX, Canvas.ClipY);
	Canvas.SetOrigin(OldOriginX, Canvas.OrgY);

	if ( PlayerOwner.bShowScores || bForceScores )
	{
		if ( (PlayerOwner.Scoring == None) && (PlayerOwner.ScoringType != None) )
			PlayerOwner.Scoring = Spawn(PlayerOwner.ScoringType, PlayerOwner);
		if ( PlayerOwner.Scoring != None )
		{ 
			PlayerOwner.Scoring.OwnerHUD = self;
			PlayerOwner.Scoring.ShowScores(Canvas);
			if ( PlayerOwner.Player.Console.bTyping )
				DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);
			return;
		}
	}

	YPos = FMax(YL*4 + 8, 70*Scale);
	if ( bDrawFaceArea )
		DrawTalkFace( Canvas,0, YPos );
	if (j > 0) 
	{
		bDrawMessageArea = True;
		MessageFadeCount = 2;
	} 
	else 
		bDrawMessageArea = False;

	if ( !bHideCenterMessages )
	{
		// Master localized message control loop.
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message != None)
			{
				if (LocalMessages[i].Message.Default.bFadeMessage && Level.bHighDetailMode)
				{
					Canvas.Style = ERenderStyle.STY_Translucent;
					FadeValue = (LocalMessages[i].EndOfLife - Level.TimeSeconds);
					if (FadeValue > 0.0)
					{
						if ( bResChanged || (LocalMessages[i].XL == 0) )
						{
							if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
								LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
							else // ==2
								LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
							Canvas.Font = LocalMessages[i].StringFont;
							Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
							LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
						}
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.DrawColor = LocalMessages[i].DrawColor * (FadeValue/LocalMessages[i].LifeTime);
						Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
						Canvas.DrawText( LocalMessages[i].StringMessage, False );
					}
				} 
				else 
				{
					if ( bResChanged || (LocalMessages[i].XL == 0) )
					{
						if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
							LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
						else // == 2
							LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
						LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
					}
					Canvas.Font = LocalMessages[i].StringFont;
					Canvas.Style = ERenderStyle.STY_Normal;
					Canvas.DrawColor = LocalMessages[i].DrawColor;
					Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
					Canvas.DrawText( LocalMessages[i].StringMessage, False );
				}
			}
		}
	}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( !PlayerOwner.bBehindView && (PawnOwner.Weapon != None) && (Level.LevelAction == LEVACT_None) )
	{
		Canvas.DrawColor = WhiteColor;
		PawnOwner.Weapon.PostRender(Canvas);
		if ( !PawnOwner.Weapon.bOwnsCrossHair )
			DrawCrossHair(Canvas, 0,0 );
	}

	if ( (PawnOwner != Owner) && PawnOwner.bIsPlayer )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.bCenter = true;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = CyanColor * TutIconBlink;
		Canvas.SetPos(4, Canvas.ClipY - 96 * Scale);
		Canvas.DrawText( LiveFeed$PawnOwner.PlayerReplicationInfo.PlayerName, true );
		Canvas.bCenter = false;
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = Style;
	}

	if ( bStartUpMessage && (Level.TimeSeconds < 5) )
	{
		bStartUpMessage = false;
		PlayerOwner.SetProgressTime(7);
	}
	if ( (PlayerOwner.ProgressTimeOut > Level.TimeSeconds) && !bHideCenterMessages )
		DisplayProgressMessage(Canvas);

	// Display MOTD
	if ( MOTDFadeOutTime > 0.0 )
		DrawMOTD(Canvas);


		 
	if( !bHideHUD )
	{
		if ( !PawnOwner.PlayerReplicationInfo.bIsSpectator )
		{
			Canvas.Style = Style;

			// Draw Ammo
			if ( !bHideAmmo )
				DrawAmmo(Canvas);
			

		}


		// Team Game Synopsis
		if ( !bHideTeamInfo )
			DrawGameSynopsis(Canvas);

		// Display Identification Info
		if ( PawnOwner == PlayerOwner )
			DrawIdentifyInfo(Canvas);

		if ( HUDMutator != None )
			HUDMutator.PostRender(Canvas);

		if ( (PlayerOwner.GameReplicationInfo != None) && (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) ) 
		{
			if ( TimeMessageClass == None )
				TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

			if ( (PlayerOwner.GameReplicationInfo.RemainingTime <= 300)
			  && (PlayerOwner.GameReplicationInfo.RemainingTime != LastReportedTime) )
			{
				LastReportedTime = PlayerOwner.GameReplicationInfo.RemainingTime;
				if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 30 )
				{
					bTimeValid = ( bTimeValid || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) );	
					if ( PlayerOwner.GameReplicationInfo.RemainingTime == 30 )
						TellTime(5);
					else if ( bTimeValid && PlayerOwner.GameReplicationInfo.RemainingTime <= 10 )
						TellTime(16 - PlayerOwner.GameReplicationInfo.RemainingTime);
				}
				else if ( PlayerOwner.GameReplicationInfo.RemainingTime % 60 == 0 )
				{
					M = PlayerOwner.GameReplicationInfo.RemainingTime/60;
					TellTime(5 - M);
				}
			}
		}
	}
	if ( PlayerOwner.Player.Console.bTyping )
		DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);

	if ( PlayerOwner.bBadConnectionAlert && (PlayerOwner.Level.TimeSeconds > 5) )
	{
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - (64*Scale), Canvas.ClipY / 2);
		Canvas.DrawIcon(texture'DisconnectWarn', Scale);
	}
}

defaultproperties
{
     bInfoOpen=True
     BlackColor=(R=255,G=255,B=0)
}
